#!/bin/bash

# 安装路径配置
INFORMAT_HOME_PATH="/informat-next"
HOME_PATH="/tmp"
JDK_PATH="$INFORMAT_HOME_PATH/jdk"
PG_DIR="/usr/local/pgsql"

# 检查是否已编译安装 jdbc_fdw
echo "检查是否已编译安装 jdbc_fdw..."

PG_LIB_DIR="$PG_DIR/lib"
PG_SHARE_DIR="$PG_DIR/share/extension"

# 搜索 jdbc_fdw.so 和 jdbc_fdw.control
JDBC_FDW_SO="$PG_LIB_DIR/jdbc_fdw.so"
JDBC_FDW_CONTROL="$PG_SHARE_DIR/jdbc_fdw.control"

if [ -f "$JDBC_FDW_SO" ] && [ -f "$JDBC_FDW_CONTROL" ]; then
    echo "jdbc_fdw 已编译安装（找到 JDBC_FDW_SO 和 JDBC_FDW_CONTROL），跳过安装步骤。"
    echo "JDBC_FDW_SO: $JDBC_FDW_SO"
    echo "JDBC_FDW_CONTROL: $JDBC_FDW_CONTROL"
    exit 0
else
    echo "未找到完整的 jdbc_fdw 安装，继续安装过程..."
    echo "查找结果:"
    echo "  $JDBC_FDW_SO: $( [ -f "$JDBC_FDW_SO" ] && echo "存在" || echo "不存在" )"
    echo "  $JDBC_FDW_CONTROL: $( [ -f "$JDBC_FDW_CONTROL" ] && echo "存在" || echo "不存在" )"
fi

# echo "安装编译依赖..."
# cd "$HOME_PATH/debs"
# sudo dpkg -i ./*.deb

echo "配置JDK环境..."
sudo chmod +x ${JDK_PATH}/bin/java
sudo chmod +x ${JDK_PATH}/bin/javac

# 写入系统环境变量文件（而不是用 sudo source）
sudo tee /etc/profile.d/jdk.sh > /dev/null <<EOF
export JAVA_HOME="$JDK_PATH"
export PATH="\$JAVA_HOME/bin:\$PATH"
export LD_LIBRARY_PATH="\$JAVA_HOME/lib/server:\$LD_LIBRARY_PATH"
EOF
sudo chmod +x /etc/profile.d/jdk.sh

# 当前脚本中生效环境变量
export JAVA_HOME="$JDK_PATH"
export PATH="$JAVA_HOME/bin:$PATH"
export LD_LIBRARY_PATH="$JAVA_HOME/lib/server:$LD_LIBRARY_PATH"

# 建立 libjvm.so 的软链接
sudo ln -sf "$JAVA_HOME/lib/server/libjvm.so" /usr/lib/x86_64-linux-gnu/libjvm.so

echo "验证Java安装..."
if ! java -version; then
  echo "JDK配置失败"
  exit 1
fi

# 拷贝 jar 包
sudo mkdir -p /opt/fdw/
sudo mv "$HOME_PATH/jar/mssql-jdbc-12.10.0.jre11.jar" /opt/fdw/

# 解压源码
echo "配置PostgreSQL扩展..."
mkdir -p "$HOME_PATH/tmps"
sudo unzip -q "$HOME_PATH/jdbc_fdw_1.2.zip" -d "$HOME_PATH/tmps"
cd "$HOME_PATH/tmps"
# 加上环境变量保证 make 时能找到 javac
make USE_PGXS=1 PG_CONFIG="$PG_DIR/bin/pg_config" JAVA_HOME="$JAVA_HOME" PATH="$JAVA_HOME/bin:$PATH"
make USE_PGXS=1 PG_CONFIG="$PG_DIR/bin/pg_config" JAVA_HOME="$JAVA_HOME" PATH="$JAVA_HOME/bin:$PATH" install

echo "配置postgres用户环境..."
# 复制 JDK 给 postgres 用户
sudo mkdir -p /var/lib/postgresql/jdk
sudo cp -r "$JDK_PATH"/* /var/lib/postgresql/jdk/
sudo chown -R postgres:postgres /var/lib/postgresql/jdk

# 设置环境变量脚本
ENV_SCRIPT="/var/lib/postgresql/jdk/jdk_env.sh"
sudo tee "$ENV_SCRIPT" > /dev/null <<EOF
export JAVA_HOME="/var/lib/postgresql/jdk"
export PATH="\$JAVA_HOME/bin:\$PATH"
export LD_LIBRARY_PATH="\$JAVA_HOME/lib/server:\$LD_LIBRARY_PATH"
EOF
sudo chown postgres:postgres "$ENV_SCRIPT"
sudo chmod +x "$ENV_SCRIPT"

# 强制在 postgres 用户 shell 中手动加载 jdk_env.sh（不要依赖 bashrc）
sudo -u postgres bash -c "source $ENV_SCRIPT && java -version" || {
  echo "配置postgres用户环境失败..."
  exit 1
}

echo "jdbc_fdw 安装完成！"
